# Chrome Extension Template

这是一个简洁的Chrome插件开发模板，包含了开发Chrome插件所需的基础文件和结构。

## 项目结构

```
chrome-extension-template/
├── manifest.json          # 插件配置文件
├── popup.html             # 弹出窗口HTML
├── popup.js               # 弹出窗口脚本
├── background.js          # 后台服务脚本
├── contentScript.js       # 内容脚本（注入到网页中）
├── options.html           # 设置页面HTML
├── options.js             # 设置页面脚本
├── icons/                 # 插件图标
│   └── icon.png           # 48x48像素的图标
└── README.md              # 说明文档
```

## 功能特性

- ✅ Manifest V3 支持
- ✅ 美观的弹出窗口界面
- ✅ 完整的设置页面
- ✅ 数据存储功能
- ✅ 跨脚本通信
- ✅ 内容脚本注入
- ✅ 配置导入导出

## 快速开始

### 1. 克隆模板

```bash
git clone <repository-url>
cd chrome-extension-template
```

### 2. 修改配置

编辑 `manifest.json` 文件，修改以下信息：

```json
{
    "name": "你的插件名称",
    "version": "1.0.0",
    "description": "你的插件描述"
}
```

### 3. 开发自定义功能

#### 弹出窗口功能

在 `popup.js` 中添加你的功能逻辑：

```javascript
// 示例：添加新按钮功能
document.getElementById('myButton').addEventListener('click', function() {
    // 你的功能代码
    showResult('功能执行结果');
});
```

#### 后台脚本

在 `background.js` 中处理后台任务：

```javascript
// 监听消息示例
chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    if (request.action === 'myAction') {
        // 处理逻辑
        sendResponse({ result: 'success' });
    }
});
```

#### 内容脚本

在 `contentScript.js` 中操作网页内容：

```javascript
// 操作页面DOM示例
function modifyPage() {
    const elements = document.querySelectorAll('p');
    elements.forEach(el => {
        el.style.backgroundColor = 'yellow';
    });
}
```

### 4. 加载插件

1. 打开Chrome浏览器
2. 访问 `chrome://extensions/`
3. 开启"开发者模式"
4. 点击"加载已解压的扩展程序"
5. 选择插件文件夹

## 文件说明

### manifest.json
Chrome插件的核心配置文件，定义了插件的基本信息、权限和文件路径。

### popup.html / popup.js
弹出窗口相关文件，用户点击插件图标时显示。

### background.js
后台服务脚本，持续运行，处理插件的后台逻辑。

### contentScript.js
内容脚本，注入到网页中，可以访问和修改网页内容。

### options.html / options.js
设置页面，提供插件配置功能。

## 开发指南

### 权限设置

在 `manifest.json` 中根据需要添加权限：

```json
"permissions": [
    "storage",      // 本地存储
    "tabs",         // 标签页操作
    "activeTab",    // 活动标签页
    "scripting",    // 脚本注入
    "notifications" // 系统通知
]
```

### 消息传递

各脚本之间的通信示例：

```javascript
// 从popup发送消息到background
chrome.runtime.sendMessage({
    action: 'myAction',
    data: myData
}, function(response) {
    console.log(response);
});

// 在background中接收消息
chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    if (request.action === 'myAction') {
        // 处理消息
        sendResponse({ success: true });
    }
});
```

### 数据存储

使用Chrome Storage API存储数据：

```javascript
// 保存数据
chrome.storage.local.set({ key: 'value' });

// 读取数据
chrome.storage.local.get(['key'], function(result) {
    console.log(result.key);
});
```

## 最佳实践

1. **代码组织**: 将不同功能的代码分别放在对应的文件中
2. **错误处理**: 添加适当的错误处理和用户反馈
3. **性能优化**: 避免在contentScript中执行耗时操作
4. **用户体验**: 提供清晰的界面和操作反馈
5. **安全考虑**: 验证用户输入，避免XSS攻击

## 调试技巧

### 弹出窗口调试
1. 右键点击插件图标
2. 选择"检查弹出内容"

### 后台脚本调试
1. 打开 `chrome://extensions/`
2. 找到插件，点击"服务工作进程"或"背景页"

### 内容脚本调试
1. 在目标网页右键
2. 选择"检查"
3. 在Console中查看contentScript的日志

## 发布准备

1. **测试兼容性**: 在不同版本的Chrome中测试
2. **优化性能**: 减少内存使用和CPU占用
3. **完善文档**: 编写用户使用说明
4. **图标设计**: 设计美观的插件图标
5. **打包发布**: 在Chrome Web Store发布

## 常见问题

### Q: 如何让插件在特定网站运行？
A: 在manifest.json中添加content_scripts配置：

```json
"content_scripts": [{
    "matches": ["https://*.example.com/*"],
    "js": ["contentScript.js"]
}]
```

### Q: 如何保存用户设置？
A: 使用chrome.storage.local或chrome.storage.sync

### Q: 如何在不同页面间共享数据？
A: 使用background脚本作为数据中转站

## 许可证

MIT License

## 贡献

欢迎提交Issue和Pull Request来改进这个模板！